package music;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

/**
 * Write a description of class Song here.
 * 
 * @author (your name) 
 * @version (a version number or a date)
 */

public class Song implements Serializable {
    private static String description;
    
    private static final long serialVersionUID = 42L;
    
    private String title;
    private Author author;
    private int year;
    
    static {
        description = "A nice piece of music";
    }
    
    public Song(String title, Author author, int year, String description) {
        this.title = title;
        this.author = author;
        this.year = year;
        this.description = description;
    }
    
    public Song(String title, Author author, int year) {
        this.title = title;
        this.author = author;
        this.year = year;
    }
    
    public Song(String title) {
        this.title = title;
    }
    
//     public Song() {
    public Song() {
    }
    
    public void display() {
        System.out.println(
            "title: " + '\"' + this.title + '\"' + '\n' +
            "author: " + this.getAuthor().getName() + '\n' +
            "year: " + this.year);
    }
    
    public void serialize(String filename) {
        File f = new File(filename);
//        ObjectOutputStream out = null;
//        try {
//            out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(f)));
//            out.writeObject(this);
//        } catch (IOException e) {
//            // TODO Auto-generated catch block
//            e.printStackTrace();
//        } finally {
//            if (out != null) {
//                try {
//                    out.close();
//                } catch (IOException e) {
//                    // TODO Auto-generated catch block
//                    e.printStackTrace();
//                }
//            }
//        }
        
        try (ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(f)))) {
            out.writeObject(this);
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }
    
    public static Song deserialize(String filename) {
        File f = new File(filename);
        Song s = new Song();
        try (ObjectInputStream in = new ObjectInputStream(new FileInputStream(f))) {
            s = (Song) in.readObject();
            in.close();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (ClassNotFoundException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return s;
    }
    
    @Override
    public boolean equals(Object obj) {
    	if (!(obj instanceof Song)) {
    		return false;
    	}
    	Song song = (Song) obj;
    	if ((song.getTitle().equals(this.getTitle())) &&
    		(song.getYear() == this.getYear())) {
    		return true;
    	}
    	return false;
    }
    
    public void setTitle(String title) {
        this.title = title;
    }
    
    public String getTitle() {
        return this.title;
    }
    
    public void setAuthor(Author author) {
        this.author = author;
    }
    
    public Author getAuthor() {
        return this.author;
    }
    
    public void setYear(int year) {
        this.year = year;
    }
    
    public int getYear() {
        return this.year;
    }
    
    public void setDescription(String description) {
        this.description = description;
    }
    
    public String getDescription() {
        return this.description;
    }
    
}
